BEGIN TRY
DECLARE @ErrorMsg VARCHAR(1000)
DECLARE @Referral_ID INT 
DECLARE @Col1 int 

--Add the Columns
IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'Referral_NonCriteria_Flag'
AND object_id=OBJECT_ID(N'crs.referral'))
   ALTER TABLE CRS.REFERRAL
   Drop column Referral_NonCriteria_Flag BIT NULL;
IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'Referral_NonCriteria_Flag'
AND object_id=OBJECT_ID(N'crs.referral_h'))
    ALTER TABLE CRS.Referral_H
    Drop column Referral_NonCriteria_Flag BIT NULL;

IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'Referral_NonCriteria_Flag'
AND object_id=OBJECT_ID(N'crs.referral'))
  BEGIN
  UPDATE CRS.CRS.Referral 
  SET [Referral_NonCriteria_Flag] = 0
  FROM [CRS].[CRS].[STD_REFERRALSTS] AS sr 
       INNER JOIN crs.crs.REFERRAL  AS r 
       ON sr.STD_REGISTRY_ID = r.STD_REGISTRY_ID
       AND r.STD_REFERRALSTS_ID = sr.ID
  WHERE 
  code IN ('DISQUALIFIED','CANCELED')
  AND r.[Referral_NonCriteria_Flag] = 1
  END
END TRY
BEGIN CATCH
      SELECT @ErrorMsg = 'Error Rollback Referral_NonCriteria_Flag)'
	  EXEC [CRS].[InsDBLog] 0, 1, 'CRS.Referral', @ErrorMsg,'', ''
END CATCH
GO